/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sos.binding;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.n52.iceland.binding.AbstractXmlBinding;
import org.n52.iceland.binding.BindingKey;
import org.n52.iceland.binding.MediaTypeBindingKey;
import org.n52.iceland.binding.PathBindingKey;
import org.n52.iceland.coding.SupportedTypeRepository;
import org.n52.iceland.exception.HTTPException;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.janmayen.stream.Streams;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.ows.OWSConstants;
import org.n52.shetland.ogc.ows.exception.MissingParameterValueException;
import org.n52.shetland.ogc.ows.exception.NoApplicableCodeException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.extension.Extension;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.shetland.ogc.sensorML.AbstractProcess;
import org.n52.shetland.ogc.sensorML.AbstractSensorML;
import org.n52.shetland.ogc.sensorML.SensorML;
import org.n52.shetland.ogc.sensorML.elements.SmlIo;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.SosInsertionMetadata;
import org.n52.shetland.ogc.sos.SosOffering;
import org.n52.shetland.ogc.sos.SosProcedureDescription;
import org.n52.shetland.ogc.sos.request.InsertSensorRequest;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.SweAbstractDataRecord;
import org.n52.shetland.ogc.swe.SweField;
import org.n52.shetland.ogc.swe.simpleType.SweBoolean;
import org.n52.shetland.ogc.swes.SwesExtension;
import org.n52.shetland.util.OMHelper;
import org.n52.sos.exception.swes.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterBinding
extends AbstractXmlBinding<OwsServiceRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisterBinding.class);
    private static final String URL_PATTERN = "/register";
    private static final String PROCEDURE = "procedure";
    private static final String OFFERING = "offering";
    private static final String IS_TYPE = "isType";
    private static final Set<BindingKey> KEYS = ImmutableSet.builder().add((Object)new PathBindingKey("/register")).add((Object)new MediaTypeBindingKey(MediaTypes.APPLICATION_XML)).build();
    @Inject
    private SupportedTypeRepository supportedTypeRepository;

    public Set<BindingKey> getKeys() {
        return Collections.unmodifiableSet(KEYS);
    }

    public String getUrlPattern() {
        return URL_PATTERN;
    }

    protected MediaType getDefaultContentType() {
        return MediaTypes.APPLICATION_XML;
    }

    protected boolean isUseHttpResponseCodes() {
        return false;
    }

    public void doPostOperation(HttpServletRequest req, HttpServletResponse res) throws HTTPException, IOException {
        OwsServiceRequest serviceRequest = null;
        try {
            serviceRequest = this.parseRequest(req);
            serviceRequest.setRequestContext(this.getRequestContext(req));
            OwsServiceResponse response = this.getServiceOperator(serviceRequest).receiveRequest(serviceRequest);
            this.writeResponse(req, res, response);
        }
        catch (OwsExceptionReport oer) {
            oer.setVersion(serviceRequest != null ? serviceRequest.getVersion() : null);
            this.writeOwsExceptionReport(req, res, oer);
        }
    }

    private OwsServiceRequest parseRequest(HttpServletRequest req) throws OwsExceptionReport {
        Map<String, String> parameters = Streams.stream((Enumeration)req.getParameterNames()).collect(Collectors.toMap(name -> name.replace("amp;", "").toLowerCase(Locale.ROOT), arg_0 -> ((HttpServletRequest)req).getParameter(arg_0)));
        Object object = this.decode(req);
        if (object != null) {
            SosProcedureDescription procDesc = null;
            if (object instanceof SosProcedureDescription) {
                procDesc = (SosProcedureDescription)object;
            } else if (object instanceof AbstractFeature) {
                procDesc = new SosProcedureDescription((AbstractFeature)object);
            } else {
                throw new NoApplicableCodeException().withMessage("The requested type '{}' is not supported!", new Object[]{object.getClass().getName()});
            }
            InsertSensorRequest request = new InsertSensorRequest();
            request.setRequestContext(this.getRequestContext(req));
            String isType = this.getParameterValue(IS_TYPE, parameters);
            boolean isTypeRequest = false;
            if (!Strings.isNullOrEmpty((String)isType) && Boolean.parseBoolean(isType)) {
                SwesExtension extension = new SwesExtension();
                extension.setDefinition(IS_TYPE).setValue((Object)new SweBoolean().setValue(Boolean.valueOf(true)));
                request.addExtension((Extension)extension);
                isTypeRequest = true;
            }
            this.checkForProcedureParameter(procDesc, parameters);
            this.checkForOfferingParameter(procDesc, parameters);
            request.setProcedureDescription(procDesc);
            request.setService(this.getServiceParameterValue(parameters));
            request.setVersion(this.getVersionParameterValue(parameters));
            request.setProcedureDescriptionFormat(procDesc.getDescriptionFormat());
            List<String> observableProperties = this.checkForObservablePropertyParameter(procDesc, parameters);
            if (!observableProperties.isEmpty()) {
                request.setObservableProperty(observableProperties);
            } else if (procDesc.getProcedureDescription() instanceof AbstractSensorML) {
                request.setObservableProperty(this.getObservablePropertyFromAbstractSensorML((AbstractSensorML)procDesc.getProcedureDescription()));
            } else if (isTypeRequest) {
                request.setObservableProperty((List)Lists.newArrayList((Object[])new String[]{"not_defined"}));
            } else {
                throw new NoApplicableCodeException().withMessage("The sensor description does not contain sml:outputs which is used to fetch the possible observableProperties! Please add an sml:ouput section or define the observableProperties via 'observableProperty' URL parameter!'", new Object[0]);
            }
            if (!isTypeRequest) {
                SosInsertionMetadata metadata = new SosInsertionMetadata();
                List<String> featureOfInterestTypes = this.checkForFeatureOfInterestTypeParameter(procDesc, parameters);
                if (!featureOfInterestTypes.isEmpty()) {
                    metadata.setFeatureOfInterestTypes(featureOfInterestTypes);
                } else {
                    metadata.setFeatureOfInterestTypes((Collection)this.supportedTypeRepository.getFeatureOfInterestTypesAsString());
                }
                List<String> observationTypes = this.checkForObservationTypeParameter(procDesc, parameters);
                if (!observationTypes.isEmpty()) {
                    metadata.setObservationTypes(observationTypes);
                } else if (procDesc.getProcedureDescription() instanceof AbstractProcess && ((AbstractProcess)procDesc.getProcedureDescription()).isSetOutputs()) {
                    metadata.setObservationTypes(this.getObservationTypeFrom(((AbstractProcess)procDesc.getProcedureDescription()).getOutputs()));
                } else if (procDesc.getProcedureDescription() instanceof SensorML && ((SensorML)procDesc.getProcedureDescription()).isWrapper()) {
                    HashSet obsTyp = Sets.newHashSet();
                    for (AbstractProcess abstractProcess : ((SensorML)procDesc.getProcedureDescription()).getMembers()) {
                        if (!abstractProcess.isSetOutputs()) continue;
                        obsTyp.addAll(this.getObservationTypeFrom(abstractProcess.getOutputs()));
                    }
                    metadata.setObservationTypes((Collection)obsTyp);
                } else {
                    metadata.setObservationTypes((Collection)this.supportedTypeRepository.getObservationTypesAsString());
                }
                request.setMetadata(metadata);
            }
            return request;
        }
        throw new InvalidRequestException().withMessage("The requested sensor description null is not supported!", new Object[0]);
    }

    private String getServiceParameterValue(Map<String, String> map) {
        String service = this.getParameterValue((Enum<?>)OWSConstants.RequestParams.service, map);
        if (Strings.isNullOrEmpty((String)service)) {
            return "SOS";
        }
        return service;
    }

    private String getVersionParameterValue(Map<String, String> map) {
        String version = this.getParameterValue((Enum<?>)OWSConstants.RequestParams.version, map);
        if (Strings.isNullOrEmpty((String)version)) {
            return "2.0.0";
        }
        return version;
    }

    private void checkForProcedureParameter(SosProcedureDescription<?> procDesc, Map<String, String> map) {
        String procedure = this.getParameterValue(PROCEDURE, map);
        if (!Strings.isNullOrEmpty((String)procedure)) {
            procDesc.setIdentifier(new CodeWithAuthority(procedure));
        }
    }

    private void checkForOfferingParameter(SosProcedureDescription<?> procDesc, Map<String, String> map) throws OwsExceptionReport {
        String offerings = this.getParameterValue(OFFERING, map);
        if (!Strings.isNullOrEmpty((String)offerings)) {
            List<String> multipleOfferingValues = this.checkParameterMultipleValues(offerings, OFFERING);
            for (String offering : multipleOfferingValues) {
                procDesc.addOffering(new SosOffering(offering, offering));
            }
        }
    }

    private List<String> checkForObservablePropertyParameter(SosProcedureDescription<?> procDesc, Map<String, String> map) throws OwsExceptionReport {
        String offering = this.getParameterValue((Enum<?>)Sos2Constants.InsertSensorParams.observableProperty, map);
        if (!Strings.isNullOrEmpty((String)offering)) {
            return this.checkParameterMultipleValues(offering, (Enum<?>)Sos2Constants.InsertSensorParams.observableProperty);
        }
        return Collections.emptyList();
    }

    private List<String> checkForObservationTypeParameter(SosProcedureDescription<?> procDesc, Map<String, String> map) throws OwsExceptionReport {
        String offering = this.getParameterValue((Enum<?>)Sos2Constants.InsertSensorParams.observationType, map);
        if (!Strings.isNullOrEmpty((String)offering)) {
            return this.checkParameterMultipleValues(offering, (Enum<?>)Sos2Constants.InsertSensorParams.observationType);
        }
        return Collections.emptyList();
    }

    private List<String> checkForFeatureOfInterestTypeParameter(SosProcedureDescription<?> procDesc, Map<String, String> map) throws OwsExceptionReport {
        String offering = this.getParameterValue((Enum<?>)Sos2Constants.InsertSensorParams.featureOfInterestType, map);
        if (!Strings.isNullOrEmpty((String)offering)) {
            return this.checkParameterMultipleValues(offering, (Enum<?>)Sos2Constants.InsertSensorParams.featureOfInterestType);
        }
        return Collections.emptyList();
    }

    private String getObservablePropertyIdentifierFrom(SweAbstractDataComponent abstractDataComponent) {
        if (abstractDataComponent.isSetIdentifier()) {
            return abstractDataComponent.getIdentifier();
        }
        if (abstractDataComponent.isSetDefinition()) {
            return abstractDataComponent.getDefinition();
        }
        return null;
    }

    private List<String> getObservablePropertyFromAbstractSensorML(AbstractSensorML absSensorML) {
        HashSet obsProps;
        block8: {
            block7: {
                obsProps = Sets.newHashSet();
                if (!(absSensorML instanceof AbstractProcess) || !((AbstractProcess)absSensorML).isSetOutputs()) break block7;
                for (SmlIo smlIo : ((AbstractProcess)absSensorML).getOutputs()) {
                    if (smlIo.isSetValue().booleanValue()) {
                        String identifier;
                        SweAbstractDataComponent abstractDataComponent = smlIo.getIoValue();
                        if (abstractDataComponent instanceof SweAbstractDataRecord) {
                            for (SweField field : ((SweAbstractDataRecord)abstractDataComponent).getFields()) {
                                String identifier2 = this.getObservablePropertyIdentifierFrom(field.getElement());
                                if (!Strings.isNullOrEmpty((String)identifier2)) {
                                    obsProps.add(identifier2);
                                    continue;
                                }
                                String identifierFromField = this.getObservablePropertyIdentifierFrom(field.getElement());
                                if (!Strings.isNullOrEmpty((String)identifierFromField)) {
                                    obsProps.add(identifierFromField);
                                    continue;
                                }
                                obsProps.add(field.getName().getValue());
                            }
                        }
                        if (Strings.isNullOrEmpty((String)(identifier = this.getObservablePropertyIdentifierFrom(abstractDataComponent)))) continue;
                        obsProps.add(identifier);
                        continue;
                    }
                    if (!smlIo.isSetName()) continue;
                    obsProps.add(smlIo.getIoName());
                }
                break block8;
            }
            if (!(absSensorML instanceof SensorML) || !((SensorML)absSensorML).isWrapper()) break block8;
            for (AbstractProcess abstractProcess : ((SensorML)absSensorML).getMembers()) {
                obsProps.addAll(this.getObservablePropertyFromAbstractSensorML((AbstractSensorML)abstractProcess));
            }
        }
        return Lists.newArrayList((Iterable)obsProps);
    }

    private Set<String> getObservationTypeFrom(List<SmlIo> outputs) {
        HashSet observationTypes = Sets.newHashSet();
        for (SmlIo smlIo : outputs) {
            if (!smlIo.isSetValue().booleanValue()) continue;
            try {
                if (smlIo.getIoValue() instanceof SweAbstractDataRecord) {
                    for (SweField field : ((SweAbstractDataRecord)smlIo.getIoValue()).getFields()) {
                        observationTypes.add(OMHelper.getObservationTypeFrom((SweAbstractDataComponent)field.getElement()));
                    }
                }
                observationTypes.add(OMHelper.getObservationTypeFrom((SweAbstractDataComponent)smlIo.getIoValue()));
            }
            catch (OwsExceptionReport e) {
                observationTypes.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Observation");
                LOGGER.debug("The output element can not be assigned to an observation type", (Throwable)e);
            }
        }
        return observationTypes;
    }

    private String getParameterValue(String name, Map<String, String> map) {
        return map.computeIfAbsent(name, key -> map.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase((String)key)).findFirst().map(Map.Entry::getValue).orElse(null));
    }

    private String getParameterValue(Enum<?> name, Map<String, String> map) {
        return this.getParameterValue(name.name(), map);
    }

    public List<String> checkParameterMultipleValues(String values, String name) throws OwsExceptionReport {
        if (values.isEmpty()) {
            throw new MissingParameterValueException(name);
        }
        List<String> splittedParameterValues = Arrays.asList(values.split(","));
        for (String parameterValue : splittedParameterValues) {
            if (!Strings.isNullOrEmpty((String)parameterValue)) continue;
            throw new MissingParameterValueException(name);
        }
        return splittedParameterValues;
    }

    public List<String> checkParameterMultipleValues(String values, Enum<?> name) throws OwsExceptionReport {
        return this.checkParameterMultipleValues(values, name.name());
    }
}

